#include <iostream>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;

int N, Q;
vector<int> P;
set<int> MinCene;


bool Provera(int i) {
    if (i < 0 || i + 1 >= N) return false;
    return P[i] > P[i + 1];
}


void Zamena(int i) {
    if (i < 0 || i + 1 >= N) return false;
    if (Provera(i))
        MinCene.insert(i);
    else
        MinCene.erase(i);
}


int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    cin >> N >> Q;
    P.resize(N);
    
    for (int i = 0; i < N; ++i)
        cin >> P[i];

    
    for (int i = 0; i < N - 1; ++i)
        if (P[i] > P[i + 1])
            MinCene.insert(i);

    cout << MinCene.size() << '\n';

    while (Q--) {
        int i, j;
        cin >> i >> j;
        --i; --j;

        
        set<int> Pozicije = {i - 1, i, j - 1, j};

        for (int x : Pozicije)
            Zamena(x); 

        swap(P[i], P[j]);

        for (int x : Pozicije)
            Zamena(x); 

        cout << MinCene.size() << '\n';
    }

    return 0;
}